/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import jclass.chart.Diamond;
import jclass.chart.JCChart;
import jclass.chart.JCShape;
import jclass.chart.JCStyle;
import jclass.chart.Triangle;

public class JCSymbolStyle
extends JCStyle {
    int shape = 1;
    Color color;
    int size = 6;
    JCShape customShape;
    static int defaultColorIndex;
    public static final int NONE = 0;
    public static final int DOT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int DIAMOND = 4;
    public static final int STAR = 5;
    public static final int VERT_LINE = 6;
    public static final int HORIZ_LINE = 7;
    public static final int CROSS = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE = 10;
    public static final int OTHER = 11;
    public static int LAST;
    static int defaultShape;

    public JCSymbolStyle(int n, Color color, int n2) {
        this.setShape(n);
        this.color = color;
        this.size = n2;
    }

    public static JCSymbolStyle makeDefault(JCChart jCChart) {
        return new JCSymbolStyle(JCSymbolStyle.getDefaultShape(), JCSymbolStyle.getDefaultColor(jCChart), 6);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2, this.size);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.color);
        if (this.customShape != null) {
            this.customShape.resize(n3);
            this.customShape.draw(graphics, n, n2);
            return;
        }
        int n4 = n3 / 2;
        int n5 = (int)((double)n3 / 2.8284271247461903);
        switch (this.shape) {
            case 1: {
                graphics.fillOval(n - n3 / 2, n2 - n3 / 2, n3, n3);
                return;
            }
            case 2: {
                graphics.fillRect(n - n3 / 2, n2 - n3 / 2, n3, n3);
                return;
            }
            case 5: {
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                graphics.drawLine(n - n5, n2 - n5, n + n5, n2 + n5);
                graphics.drawLine(n - n5, n2 + n5, n + n5, n2 - n5);
                return;
            }
            case 6: {
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                return;
            }
            case 7: {
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                return;
            }
            case 8: {
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                return;
            }
            case 9: {
                graphics.drawArc(n - n3 / 2, n2 - n3 / 2, n3 - 1, n3 - 1, 0, 360);
                return;
            }
            case 10: {
                graphics.drawRect(n - n3 / 2, n2 - n3 / 2, n3 - 1, n3 - 1);
                return;
            }
        }
    }

    public int getShape() {
        return this.shape;
    }

    public synchronized void setShape(int n) {
        if (this.shape == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.shape = n;
                this.customShape = null;
                break;
            }
            case 3: {
                this.shape = n;
                this.customShape = new Triangle();
                break;
            }
            case 4: {
                this.shape = n;
                this.customShape = new Diamond();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Shape in JCSymbolStyle.");
            }
        }
        this.setChanged(true);
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        if (this.size == n) {
            return;
        }
        this.size = n;
        this.setChanged(true);
    }

    static int getDefaultShape() {
        int n = defaultShape++;
        if (defaultShape > LAST) {
            defaultShape = 1;
        }
        return n;
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color = JCStyle.defaultColors[defaultColorIndex++];
        if (jCChart != null && jCChart.chartArea != null && color == jCChart.chartArea.getPlotArea().getBackground()) {
            color = JCStyle.defaultColors[defaultColorIndex++];
        }
        if (defaultColorIndex >= JCStyle.defaultColors.length) {
            defaultColorIndex = 0;
        }
        return color;
    }

    public JCShape getCustomShape() {
        return this.customShape;
    }

    public synchronized void setCustomShape(JCShape jCShape) {
        if (this.customShape == jCShape) {
            return;
        }
        this.shape = jCShape == null ? 0 : 11;
        this.customShape = jCShape;
        this.setChanged(true);
    }

    static {
        LAST = 10;
        defaultShape = 1;
    }
}

